/*
 * Created on 7 janv. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.cocoon.readers;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.InputStream;
import java.io.BufferedInputStream;

import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.generation.DirectoryGenerator.DirValidity;
import org.apache.webdav.lib.WebdavResource;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.cocoon.util.ByteRange;
import org.apache.commons.httpclient.HttpURL;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.injac.utils.WebdavConnection;
import org.xml.sax.SAXException;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
/**
 * @author Franois Jannin
 *
 * Reader component intended to fetch webdav resources featuring identified access
 */
public class WebdavReader
extends AbstractReader
implements CacheableProcessingComponent, Parameterizable{
	 /** The list of generated documents */
    private static final Map documents = new HashMap();

    protected Source inputSource;
    protected InputStream inputStream;

    protected boolean quickTest;
    protected boolean byteRanges;

    protected Response response;
    protected Request request;
    protected long expires;
    protected int bufferSize;

    protected long configuredExpires;
    protected boolean configuredQuickTest;
    protected int configuredBufferSize;
    protected boolean configuredByteRanges;
    
	
	/**
     * The cache key needs to be generated for the configuration of this
     * generator, so storing the parameters for generateKey().
     * Using the member variables after setup() would not work I guess.
     */
	
	
    
    /** The delay between checks on updates to the filesystem. */
    protected long refreshDelay;
    /**
	 * Connection with session management
	 */
	private WebdavConnection webdavConnection;
	/**
	 * Credentials
	 */
	private String login=null;
	private String password=null;
	private String webdavpath;
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(WebdavReader.class);
	
	public void parameterize(Parameters parameters) throws ParameterException {
        this.configuredExpires = parameters.getParameterAsLong("expires", -1);
        this.configuredQuickTest = parameters.getParameterAsBoolean("quick-modified-test", false);
        this.configuredBufferSize = parameters.getParameterAsInteger("buffer-size", 8192);
        this.configuredByteRanges = parameters.getParameterAsBoolean("byte-ranges", true);
    }
	
	/* (non-Javadoc)
	 * @see org.apache.cocoon.reading.Reader#generate()
	 */
	public void generate() throws IOException, SAXException, ProcessingException {
		logger.info("WebdavReader::generate : "+webdavpath);
		String path= webdavpath.substring(webdavpath.indexOf("/slide"));
		InputStream davin = webdavConnection.getMethodData(path);
		if(davin!=null)
			inputStream  = new BufferedInputStream(davin);
		else
		{
			logger.error("WebdavReader::generate : no stream for "+webdavpath);
			return;
		}
        

        // Bugzilla Bug 25069, close inputStream in finally block
        // this will close inputStream even if processStream throws
        // an exception
        try {
        	processStream2();
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }

        if (!quickTest) {
            // if everything is ok, add this to the list of generated documents
            // (see http://marc.theaimsgroup.com/?l=xml-cocoon-dev&m=102921894301915&w=2 )
            documents.put(request.getRequestURI(), inputSource.getURI());
        }
		
			/*
			while(inputStream.available() > 0)
			{
				byte[] b= new byte[inputStream.available()];
				inputStream.read(b);
				out.write(b);
			}
			*/
		logger.debug("WebdavReader::generate : end");
	}

	/**
	 * Implementation method of org.apache.cocoon.caching.CacheableProcessingComponent
	 * @see org.apache.cocoon.caching.CacheableProcessingComponent#getKey()
	 */
	public Serializable getKey() {
		if(login!=null)
			return webdavpath+login;
		return webdavpath;
	}
	/**
	 * Implementation method of org.apache.cocoon.caching.CacheableProcessingComponent
	 * @see org.apache.cocoon.caching.CacheableProcessingComponent#getValidity()
	 */
	public SourceValidity getValidity() {
		return inputSource.getValidity();
	}
	/**
     * -Set the request parameters. Must be called before the generate method.
     * -Stock keys for caching.
     *
     * @param resolver     the SourceResolver object
     * @param objectModel  a <code>Map</code> containing model object
     * @param src          the directory to be XMLized specified as src attribute on &lt;map:generate/>
     * @param par          configuration parameters
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par)
            throws ProcessingException, SAXException, IOException {
    	super.setup(resolver, objectModel, src, par);
    	request = ObjectModelHelper.getRequest(objectModel);
        response = ObjectModelHelper.getResponse(objectModel);

        expires = par.getParameterAsLong("expires", this.configuredExpires);
        bufferSize = par.getParameterAsInteger("buffer-size", this.configuredBufferSize);

        byteRanges = par.getParameterAsBoolean("byte-ranges", this.configuredByteRanges);
        quickTest = par.getParameterAsBoolean("quick-modified-test", this.configuredQuickTest);

        try {
            inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle("Error during resolving of '" + src + "'.", se);
        }  
    	
    	if (src == null) {
            throw new ProcessingException("No src attribute pointing to a Webdav resource whom metadas to be XMLized specified.");
        }
        
        String resource= src.substring(src.lastIndexOf('/')+1);
        logger.debug("\n\n WebdavReader : resource : "+resource+"\n\n");
      
        this.webdavpath = src;	
        webdavConnection = new WebdavConnection(objectModel);
        // 1. get parameters from pipeline
        try {
			this.login=par.getParameter("login");
			this.password=par.getParameter("password");
		}
		catch(Exception e)
		{
			login=null;
			password=null;
		}
        // 2. Connect to webdavresource
        try {
        	logger.debug("WebdavReader::setup webdavpath : "+webdavpath);
			connect(webdavpath);
           	logger.debug("WebdavReader::setup : connection ressource : "+webdavpath+ " okay");
        }catch(Exception e)
		{
        	logger.error("WebdavReader::setup : Can't connect to webdav source : "+webdavpath+"\nCheck either URI is incorrect or login/password error.\n"+e.getMessage());
		}
       
    }
 
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }	
	}
	protected void processStream2() throws IOException
	{
		byte[] buffer = new byte[bufferSize];
        int length = -1;
		/*
		while(inputStream.available() > 0)
		{
			byte[] b= new byte[inputStream.available()];
			inputStream.read(b);
			out.write(b);
		}
		*/
		response.setHeader("Accept-Ranges", "none");

        while ((length = inputStream.read(buffer)) > -1) {
            out.write(buffer, 0, length);
        }
		out.flush();
	}

	protected void processStream() throws IOException, ProcessingException {
        byte[] buffer = new byte[bufferSize];
        int length = -1;

        String ranges = request.getHeader("Ranges");

        ByteRange byteRange;
        if (ranges != null && byteRanges) {
            try {
                ranges = ranges.substring(ranges.indexOf('=') + 1);
                byteRange = new ByteRange(ranges);
            } catch (NumberFormatException e) {
                byteRange = null;

                // TC: Hm.. why don't we have setStatus in the Response interface ?
                if (response instanceof HttpResponse) {
                    // Respond with status 416 (Request range not satisfiable)
                    ((HttpResponse)response).setStatus(416);
                    if (getLogger().isDebugEnabled()) {
                        getLogger().debug("malformed byte range header [" + String.valueOf(ranges) + "]");
                    }
                }
            }
        }
        else {
            byteRange = null;
        }

        long contentLength = inputSource.getContentLength();

        if (byteRange != null) {
            String entityLength;
            String entityRange;
            if (contentLength != -1) {
                entityLength = "" + contentLength;
                entityRange = byteRange.intersection(new ByteRange(0, contentLength)).toString();
            } else {
                entityLength = "*";
                entityRange = byteRange.toString();
            }

            response.setHeader("Content-Range", entityRange + "/" + entityLength);

            if (response instanceof HttpResponse) {
                // Response with status 206 (Partial content)
                ((HttpResponse)response).setStatus(206);
            }

            response.setHeader("Accept-Ranges", "bytes");

            int pos = 0;
            int posEnd;
            while ((length = inputStream.read(buffer)) > -1) {
                posEnd = pos + length - 1;
                ByteRange intersection = byteRange.intersection(new ByteRange(pos, posEnd));
                if (intersection != null) {
                    out.write(buffer, (int) intersection.getStart() - pos, (int) intersection.length());
                }
                pos += length;
            }
        }
        else {
            if (contentLength != -1) {
                response.setHeader("Content-Length", Long.toString(contentLength));
            }

            // Bug #9539: This resource reader does not support ranges
            response.setHeader("Accept-Ranges", "none");

            while ((length = inputStream.read(buffer)) > -1) {
                out.write(buffer, 0, length);
            }
        }

        out.flush();
    }

}
